"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def upload(
    hub,
    ctx,
    document: Dict = None,
    sync_with_public_namespace: bool = None,
    deprecate_existing_entities: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Asynchronously uploads one or more entity definitions to the user's namespace. The document parameter is required if syncWithPublicNamespace and deleteExistingEntites are false. If the syncWithPublicNamespace parameter is set to true, the user's namespace will synchronize with the latest version of the public namespace. If deprecateExistingEntities is set to true, all entities in the latest version will be deleted before the new DefinitionDocument is uploaded. When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the syncWithPublicNamespace parameter or the deprecateExistingEntities parameter to true. The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace. Valid entities are Device, DeviceModel, Service, Capability, State, Action, Event, Property, Mapping, Enum.

    Args:
        document(Dict, optional): The DefinitionDocument that defines the updated entities. Defaults to None.
        sync_with_public_namespace(bool, optional): A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to true, the upload will create a new namespace version. Defaults to None.
        deprecate_existing_entities(bool, optional): A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new DefinitionDocument. If set to true, the upload will create a new namespace version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.entity.definition.upload(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.entity.definition.upload
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="upload_entity_definitions",
        op_kwargs={
            "document": document,
            "syncWithPublicNamespace": sync_with_public_namespace,
            "deprecateExistingEntities": deprecate_existing_entities,
        },
    )
