"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the storage configuration for IoT SiteWise.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.storage_configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.storage_configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_storage_configuration",
        op_kwargs={},
    )


async def put(hub, ctx, storage_type: str, multi_layer_storage: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Configures storage settings for IoT SiteWise.

    Args:
        storage_type(str): The type of storage that you specified for your data. The storage type can be one of the following values:    SITEWISE_DEFAULT_STORAGE – IoT SiteWise replicates your data into a service managed database.    MULTI_LAYER_STORAGE – IoT SiteWise replicates your data into a service managed database and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.  .
        multi_layer_storage(Dict, optional): Identifies a storage destination. If you specified MULTI_LAYER_STORAGE for the storage type, you must specify a MultiLayerStorage object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.storage_configuration.put(ctx, storage_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.storage_configuration.put storage_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="put_storage_configuration",
        op_kwargs={
            "storageType": storage_type,
            "multiLayerStorage": multi_layer_storage,
        },
    )
