"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    portal_id: str,
    project_name: str,
    project_description: str = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a project in the specified portal.

    Args:
        portal_id(str): The ID of the portal in which to create the project.
        project_name(str): A friendly name for the project.
        project_description(str, optional): A description for the project. Defaults to None.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the project. For more information, see Tagging your IoT SiteWise resources in the IoT SiteWise User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.project.init.create(
                ctx, portal_id=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.project.init.create portal_id=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="create_project",
        op_kwargs={
            "portalId": portal_id,
            "projectName": project_name,
            "projectDescription": project_description,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, project_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a project from IoT SiteWise Monitor.

    Args:
        project_id(str): The ID of the project.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.project.init.delete(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.project.init.delete project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="delete_project",
        op_kwargs={"projectId": project_id, "clientToken": client_token},
    )


async def describe(hub, ctx, project_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a project.

    Args:
        project_id(str): The ID of the project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.project.init.describe(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.project.init.describe project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_project",
        op_kwargs={"projectId": project_id},
    )


async def list_all(
    hub, ctx, portal_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.

    Args:
        portal_id(str): The ID of the portal.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.project.init.list_all(ctx, portal_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.project.init.list_all portal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_projects",
        op_kwargs={
            "portalId": portal_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    project_id: str,
    project_name: str,
    project_description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an IoT SiteWise Monitor project.

    Args:
        project_id(str): The ID of the project to update.
        project_name(str): A new friendly name for the project.
        project_description(str, optional): A new description for the project. Defaults to None.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.project.init.update(
                ctx, project_id=value, project_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.project.init.update project_id=value, project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_project",
        op_kwargs={
            "projectId": project_id,
            "projectName": project_name,
            "projectDescription": project_description,
            "clientToken": client_token,
        },
    )
