"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    portal_name: str,
    portal_contact_email: str,
    role_arn: str,
    portal_description: str = None,
    client_token: str = None,
    portal_logo_image_file: Dict = None,
    tags: Dict = None,
    portal_auth_mode: str = None,
    notification_sender_email: str = None,
    alarms: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM to authenticate portal users and manage user permissions.  Before you can sign in to a new portal, you must add at least one identity to that portal. For more information, see Adding or removing portal administrators in the IoT SiteWise User Guide.

    Args:
        portal_name(str): A friendly name for the portal.
        portal_description(str, optional): A description for the portal. Defaults to None.
        portal_contact_email(str): The Amazon Web Services administrator's contact email address.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        portal_logo_image_file(Dict, optional): A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background. Defaults to None.
        role_arn(str): The ARN of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see Using service roles for IoT SiteWise Monitor in the IoT SiteWise User Guide.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the portal. For more information, see Tagging your IoT SiteWise resources in the IoT SiteWise User Guide. Defaults to None.
        portal_auth_mode(str, optional): The service to use to authenticate users to the portal. Choose from the following options:    SSO – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO. For more information, see Enabling Amazon Web Services SSO in the IoT SiteWise User Guide. This option is only available in Amazon Web Services Regions other than the China Regions.    IAM – The portal uses Identity and Access Management to authenticate users and manage user permissions. This option is only available in the China Regions.   You can't change this value after you create a portal. Default: SSO . Defaults to None.
        notification_sender_email(str, optional): The email address that sends alarm notifications.  If you use the IoT Events managed Lambda function to manage your emails, you must verify the sender email address in Amazon SES. . Defaults to None.
        alarms(Dict, optional): Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see Monitoring with alarms in the IoT SiteWise Application Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.portal.create(
                ctx, portal_name=value, portal_contact_email=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.portal.create portal_name=value, portal_contact_email=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="create_portal",
        op_kwargs={
            "portalName": portal_name,
            "portalDescription": portal_description,
            "portalContactEmail": portal_contact_email,
            "clientToken": client_token,
            "portalLogoImageFile": portal_logo_image_file,
            "roleArn": role_arn,
            "tags": tags,
            "portalAuthMode": portal_auth_mode,
            "notificationSenderEmail": notification_sender_email,
            "alarms": alarms,
        },
    )


async def delete(hub, ctx, portal_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a portal from IoT SiteWise Monitor.

    Args:
        portal_id(str): The ID of the portal to delete.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.portal.delete(ctx, portal_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.portal.delete portal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="delete_portal",
        op_kwargs={"portalId": portal_id, "clientToken": client_token},
    )


async def describe(hub, ctx, portal_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a portal.

    Args:
        portal_id(str): The ID of the portal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.portal.describe(ctx, portal_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.portal.describe portal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_portal",
        op_kwargs={"portalId": portal_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of IoT SiteWise Monitor portals.

    Args:
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.portal.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.portal.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_portals",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    portal_id: str,
    portal_name: str,
    portal_contact_email: str,
    role_arn: str,
    portal_description: str = None,
    portal_logo_image: Dict = None,
    client_token: str = None,
    notification_sender_email: str = None,
    alarms: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an IoT SiteWise Monitor portal.

    Args:
        portal_id(str): The ID of the portal to update.
        portal_name(str): A new friendly name for the portal.
        portal_description(str, optional): A new description for the portal. Defaults to None.
        portal_contact_email(str): The Amazon Web Services administrator's contact email address.
        portal_logo_image(Dict, optional): Contains an image that is one of the following:   An image file. Choose this option to upload a new image.   The ID of an existing image. Choose this option to keep an existing image.  . Defaults to None.
        role_arn(str): The ARN of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see Using service roles for IoT SiteWise Monitor in the IoT SiteWise User Guide.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        notification_sender_email(str, optional): The email address that sends alarm notifications. Defaults to None.
        alarms(Dict, optional): Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see Monitoring with alarms in the IoT SiteWise Application Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.portal.update(
                ctx, portal_id=value, portal_name=value, portal_contact_email=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.portal.update portal_id=value, portal_name=value, portal_contact_email=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_portal",
        op_kwargs={
            "portalId": portal_id,
            "portalName": portal_name,
            "portalDescription": portal_description,
            "portalContactEmail": portal_contact_email,
            "portalLogoImage": portal_logo_image,
            "roleArn": role_arn,
            "clientToken": client_token,
            "notificationSenderEmail": notification_sender_email,
            "alarms": alarms,
        },
    )
