"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current IoT SiteWise logging options.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.logging_option.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.logging_option.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_logging_options",
        op_kwargs={},
    )


async def put_multiple(hub, ctx, logging_options: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Sets logging options for IoT SiteWise.

    Args:
        logging_options(Dict): The logging options to set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.logging_option.put_multiple(
                ctx, logging_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.logging_option.put_multiple logging_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="put_logging_options",
        op_kwargs={"loggingOptions": logging_options},
    )
