"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    start_time_in_seconds: int,
    end_time_in_seconds: int,
    quality: str,
    interval_in_seconds: int,
    type_: str,
    asset_id: str = None,
    property_id: str = None,
    property_alias: str = None,
    start_time_offset_in_nanos: int = None,
    end_time_offset_in_nanos: int = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get interpolated values for an asset property for a specified time interval, during a period of time. For example, you can use the this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. To identify an asset property, you must specify one of the following:   The assetId and propertyId of an asset property.   A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see UpdateAssetProperty.

    Args:
        asset_id(str, optional): The ID of the asset. Defaults to None.
        property_id(str, optional): The ID of the asset property. Defaults to None.
        property_alias(str, optional): The alias that identifies the property, such as an OPC-UA server data stream path (for example, /company/windfarm/3/turbine/7/temperature). For more information, see Mapping industrial data streams to asset properties in the IoT SiteWise User Guide. Defaults to None.
        start_time_in_seconds(int): The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
        start_time_offset_in_nanos(int, optional): The nanosecond offset converted from startTimeInSeconds. Defaults to None.
        end_time_in_seconds(int): The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
        end_time_offset_in_nanos(int, optional): The nanosecond offset converted from endTimeInSeconds. Defaults to None.
        quality(str): The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.
        interval_in_seconds(int): The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. If not specified, the default value is 10. Defaults to None.
        type_(str): The interpolation type. Valid values: LINEAR_INTERPOLATION .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.interpolated_asset_property_value.get_all(
                ctx,
                start_time_in_seconds=value,
                end_time_in_seconds=value,
                quality=value,
                interval_in_seconds=value,
                type_=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.interpolated_asset_property_value.get_all start_time_in_seconds=value, end_time_in_seconds=value, quality=value, interval_in_seconds=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="get_interpolated_asset_property_values",
        op_kwargs={
            "assetId": asset_id,
            "propertyId": property_id,
            "propertyAlias": property_alias,
            "startTimeInSeconds": start_time_in_seconds,
            "startTimeOffsetInNanos": start_time_offset_in_nanos,
            "endTimeInSeconds": end_time_in_seconds,
            "endTimeOffsetInNanos": end_time_offset_in_nanos,
            "quality": quality,
            "intervalInSeconds": interval_in_seconds,
            "nextToken": next_token,
            "maxResults": max_results,
            "type": type_,
        },
    )
