"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, gateway_name: str, gateway_platform: Dict, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to IoT SiteWise. For more information, see Ingesting data using a gateway in the IoT SiteWise User Guide.

    Args:
        gateway_name(str): A unique, friendly name for the gateway.
        gateway_platform(Dict): The gateway's platform. You can only specify one platform in a gateway.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the gateway. For more information, see Tagging your IoT SiteWise resources in the IoT SiteWise User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.init.create(
                ctx, gateway_name=value, gateway_platform=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.init.create gateway_name=value, gateway_platform=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="create_gateway",
        op_kwargs={
            "gatewayName": gateway_name,
            "gatewayPlatform": gateway_platform,
            "tags": tags,
        },
    )


async def delete(hub, ctx, gateway_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your gateway's file system.

    Args:
        gateway_id(str): The ID of the gateway to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.init.delete(ctx, gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.init.delete gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="delete_gateway",
        op_kwargs={"gatewayId": gateway_id},
    )


async def describe(hub, ctx, gateway_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a gateway.

    Args:
        gateway_id(str): The ID of the gateway device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.init.describe(ctx, gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.init.describe gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_gateway",
        op_kwargs={"gatewayId": gateway_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of gateways.

    Args:
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_gateways",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(hub, ctx, gateway_id: str, gateway_name: str) -> None:
    r"""
    **Autogenerated function**

    Updates a gateway's name.

    Args:
        gateway_id(str): The ID of the gateway to update.
        gateway_name(str): A unique, friendly name for the gateway.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.init.update(
                ctx, gateway_id=value, gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.init.update gateway_id=value, gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_gateway",
        op_kwargs={"gatewayId": gateway_id, "gatewayName": gateway_name},
    )
