"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, gateway_id: str, capability_namespace: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use DescribeGateway.

    Args:
        gateway_id(str): The ID of the gateway that defines the capability configuration.
        capability_namespace(str): The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:version, where version is a number such as 1.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.capability_configuration.describe(
                ctx, gateway_id=value, capability_namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.capability_configuration.describe gateway_id=value, capability_namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_gateway_capability_configuration",
        op_kwargs={
            "gatewayId": gateway_id,
            "capabilityNamespace": capability_namespace,
        },
    )


async def update(
    hub, ctx, gateway_id: str, capability_namespace: str, capability_configuration: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use DescribeGateway.

    Args:
        gateway_id(str): The ID of the gateway to be updated.
        capability_namespace(str): The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:version, where version is a number such as 1.
        capability_configuration(str): The JSON document that defines the configuration for the gateway capability. For more information, see Configuring data sources (CLI) in the IoT SiteWise User Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.gateway.capability_configuration.update(
                ctx, gateway_id=value, capability_namespace=value, capability_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.gateway.capability_configuration.update gateway_id=value, capability_namespace=value, capability_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_gateway_capability_configuration",
        op_kwargs={
            "gatewayId": gateway_id,
            "capabilityNamespace": capability_namespace,
            "capabilityConfiguration": capability_configuration,
        },
    )
