"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the default encryption configuration for the Amazon Web Services account in the default or specified Region. For more information, see Key management in the IoT SiteWise User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.default_encryption_configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.default_encryption_configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_default_encryption_configuration",
        op_kwargs={},
    )


async def put(hub, ctx, encryption_type: str, kms_key_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Sets the default encryption configuration for the Amazon Web Services account. For more information, see Key management in the IoT SiteWise User Guide.

    Args:
        encryption_type(str): The type of encryption used for the encryption configuration.
        kms_key_id(str, optional): The Key ID of the customer managed customer master key (CMK) used for KMS encryption. This is required if you use KMS_BASED_ENCRYPTION. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.default_encryption_configuration.put(
                ctx, encryption_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.default_encryption_configuration.put encryption_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="put_default_encryption_configuration",
        op_kwargs={"encryptionType": encryption_type, "kmsKeyId": kms_key_id},
    )
