"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    project_id: str,
    dashboard_name: str,
    dashboard_definition: str,
    dashboard_description: str = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dashboard in an IoT SiteWise Monitor project.

    Args:
        project_id(str): The ID of the project in which to create the dashboard.
        dashboard_name(str): A friendly name for the dashboard.
        dashboard_description(str, optional): A description for the dashboard. Defaults to None.
        dashboard_definition(str): The dashboard definition specified in a JSON literal. For detailed information, see Creating dashboards (CLI) in the IoT SiteWise User Guide.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the dashboard. For more information, see Tagging your IoT SiteWise resources in the IoT SiteWise User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.dashboard.create(
                ctx, project_id=value, dashboard_name=value, dashboard_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.dashboard.create project_id=value, dashboard_name=value, dashboard_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="create_dashboard",
        op_kwargs={
            "projectId": project_id,
            "dashboardName": dashboard_name,
            "dashboardDescription": dashboard_description,
            "dashboardDefinition": dashboard_definition,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, dashboard_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dashboard from IoT SiteWise Monitor.

    Args:
        dashboard_id(str): The ID of the dashboard to delete.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.dashboard.delete(ctx, dashboard_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.dashboard.delete dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="delete_dashboard",
        op_kwargs={"dashboardId": dashboard_id, "clientToken": client_token},
    )


async def describe(hub, ctx, dashboard_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a dashboard.

    Args:
        dashboard_id(str): The ID of the dashboard.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.dashboard.describe(ctx, dashboard_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.dashboard.describe dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_dashboard",
        op_kwargs={"dashboardId": dashboard_id},
    )


async def list_all(
    hub, ctx, project_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.

    Args:
        project_id(str): The ID of the project.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.dashboard.list_all(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.dashboard.list_all project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_dashboards",
        op_kwargs={
            "projectId": project_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    dashboard_id: str,
    dashboard_name: str,
    dashboard_definition: str,
    dashboard_description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an IoT SiteWise Monitor dashboard.

    Args:
        dashboard_id(str): The ID of the dashboard to update.
        dashboard_name(str): A new friendly name for the dashboard.
        dashboard_description(str, optional): A new description for the dashboard. Defaults to None.
        dashboard_definition(str): The new dashboard definition, as specified in a JSON literal. For detailed information, see Creating dashboards (CLI) in the IoT SiteWise User Guide.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.dashboard.update(
                ctx, dashboard_id=value, dashboard_name=value, dashboard_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.dashboard.update dashboard_id=value, dashboard_name=value, dashboard_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_dashboard",
        op_kwargs={
            "dashboardId": dashboard_id,
            "dashboardName": dashboard_name,
            "dashboardDescription": dashboard_description,
            "dashboardDefinition": dashboard_definition,
            "clientToken": client_token,
        },
    )
