"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    asset_id: str,
    hierarchy_id: str = None,
    traversal_direction: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of associated assets. You can use this operation to do the following:   List child assets associated to a parent asset by a hierarchy that you specify.   List an asset's parent asset.

    Args:
        asset_id(str): The ID of the asset to query.
        hierarchy_id(str, optional): The ID of the hierarchy by which child assets are associated to the asset. To find a hierarchy ID, use the DescribeAsset or DescribeAssetModel operations. This parameter is required if you choose CHILD for traversalDirection. For more information, see Asset hierarchies in the IoT SiteWise User Guide. Defaults to None.
        traversal_direction(str, optional): The direction to list associated assets. Choose one of the following options:    CHILD – The list includes all child assets associated to the asset. The hierarchyId parameter is required if you choose CHILD.    PARENT – The list includes the asset's parent asset.   Default: CHILD . Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.associated_asset.list_all(ctx, asset_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.associated_asset.list_all asset_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_associated_assets",
        op_kwargs={
            "assetId": asset_id,
            "hierarchyId": hierarchy_id,
            "traversalDirection": traversal_direction,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
