"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, project_id: str, asset_ids: List, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a group (batch) of assets with an IoT SiteWise Monitor project.

    Args:
        project_id(str): The ID of the project to which to associate the assets.
        asset_ids(List): The IDs of the assets to be associated to the project.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.associate.project_asset.batch(
                ctx, project_id=value, asset_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.associate.project_asset.batch project_id=value, asset_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="batch_associate_project_assets",
        op_kwargs={
            "projectId": project_id,
            "assetIds": asset_ids,
            "clientToken": client_token,
        },
    )
