"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, asset_id: str = None, property_id: str = None, property_alias: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets an asset property's current value. For more information, see Querying current values in the IoT SiteWise User Guide. To identify an asset property, you must specify one of the following:   The assetId and propertyId of an asset property.   A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see UpdateAssetProperty.

    Args:
        asset_id(str, optional): The ID of the asset. Defaults to None.
        property_id(str, optional): The ID of the asset property. Defaults to None.
        property_alias(str, optional): The alias that identifies the property, such as an OPC-UA server data stream path (for example, /company/windfarm/3/turbine/7/temperature). For more information, see Mapping industrial data streams to asset properties in the IoT SiteWise User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.property_.value.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.property_.value.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="get_asset_property_value",
        op_kwargs={
            "assetId": asset_id,
            "propertyId": property_id,
            "propertyAlias": property_alias,
        },
    )
