"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, asset_id: str, property_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an asset property.  When you call this operation for an attribute property, this response includes the default attribute value that you define in the asset model. If you update the default value in the model, this operation's response includes the new default value.  This operation doesn't return the value of the asset property. To get the value of an asset property, use GetAssetPropertyValue.

    Args:
        asset_id(str): The ID of the asset.
        property_id(str): The ID of the asset property.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.property_.init.describe(
                ctx, asset_id=value, property_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.property_.init.describe asset_id=value, property_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_asset_property",
        op_kwargs={"assetId": asset_id, "propertyId": property_id},
    )


async def update(
    hub,
    ctx,
    asset_id: str,
    property_id: str,
    property_alias: str = None,
    property_notification_state: str = None,
    client_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates an asset property's alias and notification state.  This operation overwrites the property's existing alias and notification state. To keep your existing property's alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more information, see DescribeAssetProperty.

    Args:
        asset_id(str): The ID of the asset to be updated.
        property_id(str): The ID of the asset property to be updated.
        property_alias(str, optional): The alias that identifies the property, such as an OPC-UA server data stream path (for example, /company/windfarm/3/turbine/7/temperature). For more information, see Mapping industrial data streams to asset properties in the IoT SiteWise User Guide. If you omit this parameter, the alias is removed from the property. Defaults to None.
        property_notification_state(str, optional): The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see Interacting with other services in the IoT SiteWise User Guide. If you omit this parameter, the notification state is set to DISABLED. Defaults to None.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.property_.init.update(
                ctx, asset_id=value, property_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.property_.init.update asset_id=value, property_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_asset_property",
        op_kwargs={
            "assetId": asset_id,
            "propertyId": property_id,
            "propertyAlias": property_alias,
            "propertyNotificationState": property_notification_state,
            "clientToken": client_token,
        },
    )
