"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    aggregate_types: List,
    resolution: str,
    start_date: str,
    end_date: str,
    asset_id: str = None,
    property_id: str = None,
    property_alias: str = None,
    qualities: List = None,
    time_ordering: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets aggregated values for an asset property. For more information, see Querying aggregates in the IoT SiteWise User Guide. To identify an asset property, you must specify one of the following:   The assetId and propertyId of an asset property.   A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see UpdateAssetProperty.

    Args:
        asset_id(str, optional): The ID of the asset. Defaults to None.
        property_id(str, optional): The ID of the asset property. Defaults to None.
        property_alias(str, optional): The alias that identifies the property, such as an OPC-UA server data stream path (for example, /company/windfarm/3/turbine/7/temperature). For more information, see Mapping industrial data streams to asset properties in the IoT SiteWise User Guide. Defaults to None.
        aggregate_types(List): The data aggregating function.
        resolution(str): The time interval over which to aggregate data.
        qualities(List, optional): The quality by which to filter asset data. Defaults to None.
        start_date(str): The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
        end_date(str): The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
        time_ordering(str, optional): The chronological sorting order of the requested information. Default: ASCENDING . Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.property_.aggregate.get_all(
                ctx, aggregate_types=value, resolution=value, start_date=value, end_date=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.property_.aggregate.get_all aggregate_types=value, resolution=value, start_date=value, end_date=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="get_asset_property_aggregates",
        op_kwargs={
            "assetId": asset_id,
            "propertyId": property_id,
            "propertyAlias": property_alias,
            "aggregateTypes": aggregate_types,
            "resolution": resolution,
            "qualities": qualities,
            "startDate": start_date,
            "endDate": end_date,
            "timeOrdering": time_ordering,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
