"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    asset_id: str,
    hierarchy_id: str,
    child_asset_id: str,
    client_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For more information, see Associating assets in the IoT SiteWise User Guide.

    Args:
        asset_id(str): The ID of the parent asset.
        hierarchy_id(str): The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. For more information, see Asset hierarchies in the IoT SiteWise User Guide.
        child_asset_id(str): The ID of the child asset to be associated.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.associate(
                ctx, asset_id=value, hierarchy_id=value, child_asset_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.associate asset_id=value, hierarchy_id=value, child_asset_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="associate_assets",
        op_kwargs={
            "assetId": asset_id,
            "hierarchyId": hierarchy_id,
            "childAssetId": child_asset_id,
            "clientToken": client_token,
        },
    )


async def create(
    hub,
    ctx,
    asset_name: str,
    asset_model_id: str,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an asset from an existing asset model. For more information, see Creating assets in the IoT SiteWise User Guide.

    Args:
        asset_name(str): A unique, friendly name for the asset.
        asset_model_id(str): The ID of the asset model from which to create the asset.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        tags(Dict, optional): A list of key-value pairs that contain metadata for the asset. For more information, see Tagging your IoT SiteWise resources in the IoT SiteWise User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.create(
                ctx, asset_name=value, asset_model_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.create asset_name=value, asset_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="create_asset",
        op_kwargs={
            "assetName": asset_name,
            "assetModelId": asset_model_id,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, asset_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an asset. This action can't be undone. For more information, see Deleting assets and models in the IoT SiteWise User Guide.   You can't delete an asset that's associated to another asset. For more information, see DisassociateAssets.

    Args:
        asset_id(str): The ID of the asset to delete.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.delete(ctx, asset_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.delete asset_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="delete_asset",
        op_kwargs={"assetId": asset_id, "clientToken": client_token},
    )


async def describe(hub, ctx, asset_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an asset.

    Args:
        asset_id(str): The ID of the asset.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.describe(ctx, asset_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.describe asset_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="describe_asset",
        op_kwargs={"assetId": asset_id},
    )


async def disassociate(
    hub,
    ctx,
    asset_id: str,
    hierarchy_id: str,
    child_asset_id: str,
    client_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.

    Args:
        asset_id(str): The ID of the parent asset from which to disassociate the child asset.
        hierarchy_id(str): The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see Asset hierarchies in the IoT SiteWise User Guide.
        child_asset_id(str): The ID of the child asset to disassociate.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.disassociate(
                ctx, asset_id=value, hierarchy_id=value, child_asset_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.disassociate asset_id=value, hierarchy_id=value, child_asset_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="disassociate_assets",
        op_kwargs={
            "assetId": asset_id,
            "hierarchyId": hierarchy_id,
            "childAssetId": child_asset_id,
            "clientToken": client_token,
        },
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    asset_model_id: str = None,
    filter_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of asset summaries. You can use this operation to do the following:   List assets based on a specific asset model.   List top-level assets.   You can't use this operation to list all assets. To retrieve summaries for all of your assets, use ListAssetModels to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.

    Args:
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for each paginated request. Default: 50. Defaults to None.
        asset_model_id(str, optional): The ID of the asset model by which to filter the list of assets. This parameter is required if you choose ALL for filter. Defaults to None.
        filter_(str, optional): The filter for the requested list of assets. Choose one of the following options:    ALL – The list includes all assets for a given asset model ID. The assetModelId parameter is required if you filter by ALL.    TOP_LEVEL – The list includes only top-level assets in the asset hierarchy tree.   Default: ALL . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="list_assets",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "assetModelId": asset_model_id,
            "filter": filter_,
        },
    )


async def update(
    hub, ctx, asset_id: str, asset_name: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an asset's name. For more information, see Updating assets and models in the IoT SiteWise User Guide.

    Args:
        asset_id(str): The ID of the asset to update.
        asset_name(str): A unique, friendly name for the asset.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsitewise.asset.init.update(
                ctx, asset_id=value, asset_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsitewise.asset.init.update asset_id=value, asset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsitewise",
        operation="update_asset",
        op_kwargs={
            "assetId": asset_id,
            "assetName": asset_name,
            "clientToken": client_token,
        },
    )
