"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"open_": "open"}


async def close(hub, ctx, tunnel_id: str, delete: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Closes a tunnel identified by the unique tunnel id. When a CloseTunnel request is received, we close the WebSocket connections between the client and proxy server so no data can be transmitted.

    Args:
        tunnel_id(str): The ID of the tunnel to close.
        delete(bool, optional): When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsecuretunneling.tunnel.close(ctx, tunnel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsecuretunneling.tunnel.close tunnel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsecuretunneling",
        operation="close_tunnel",
        op_kwargs={"tunnelId": tunnel_id, "delete": delete},
    )


async def describe(hub, ctx, tunnel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a tunnel identified by the unique tunnel id.

    Args:
        tunnel_id(str): The tunnel to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsecuretunneling.tunnel.describe(ctx, tunnel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsecuretunneling.tunnel.describe tunnel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsecuretunneling",
        operation="describe_tunnel",
        op_kwargs={"tunnelId": tunnel_id},
    )


async def list_all(
    hub, ctx, thing_name: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List all tunnels for an AWS account. Tunnels are listed by creation time in descending order, newer tunnels will be listed before older tunnels.

    Args:
        thing_name(str, optional): The name of the IoT thing associated with the destination device. Defaults to None.
        max_results(int, optional): The maximum number of results to return at once. Defaults to None.
        next_token(str, optional): A token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsecuretunneling.tunnel.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsecuretunneling.tunnel.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsecuretunneling",
        operation="list_tunnels",
        op_kwargs={
            "thingName": thing_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def open_(
    hub,
    ctx,
    description: str = None,
    tags: List = None,
    destination_config: Dict = None,
    timeout_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new tunnel, and returns two client access tokens for clients to use to connect to the AWS IoT Secure Tunneling proxy server.

    Args:
        description(str, optional): A short text description of the tunnel. . Defaults to None.
        tags(List, optional): A collection of tag metadata. Defaults to None.
        destination_config(Dict, optional): The destination configuration for the OpenTunnel request. Defaults to None.
        timeout_config(Dict, optional): Timeout configuration for a tunnel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotsecuretunneling.tunnel.open(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotsecuretunneling.tunnel.open
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotsecuretunneling",
        operation="open_tunnel",
        op_kwargs={
            "description": description,
            "tags": tags,
            "destinationConfig": destination_config,
            "timeoutConfig": timeout_config,
        },
    )
