"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    application_name: str,
    role_arn: str,
    application_description: str = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Fleet Hub for AWS IoT Device Management web application.  Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.

    Args:
        application_name(str): The name of the web application.
        application_description(str, optional): An optional description of the web application. Defaults to None.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.
        role_arn(str): The ARN of the role that the web application assumes when it interacts with AWS IoT Core.  The name of the role must be in the form AWSIotFleetHub_random_string . .
        tags(Dict, optional): A set of key/value pairs that you can use to manage the web application resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotfleethub.application.create(
                ctx, application_name=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotfleethub.application.create application_name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotfleethub",
        operation="create_application",
        op_kwargs={
            "applicationName": application_name,
            "applicationDescription": application_description,
            "clientToken": client_token,
            "roleArn": role_arn,
            "tags": tags,
        },
    )


async def delete(hub, ctx, application_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Fleet Hub for AWS IoT Device Management web application.  Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.

    Args:
        application_id(str): The unique Id of the web application.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotfleethub.application.delete(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotfleethub.application.delete application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotfleethub",
        operation="delete_application",
        op_kwargs={"applicationId": application_id, "clientToken": client_token},
    )


async def describe(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Fleet Hub for AWS IoT Device Management web application.  Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.

    Args:
        application_id(str): The unique Id of the web application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotfleethub.application.describe(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotfleethub.application.describe application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotfleethub",
        operation="describe_application",
        op_kwargs={"applicationId": application_id},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.  Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.

    Args:
        next_token(str, optional): A token used to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotfleethub.application.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotfleethub.application.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotfleethub",
        operation="list_applications",
        op_kwargs={"nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    application_id: str,
    application_name: str = None,
    application_description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about a Fleet Hub for a AWS IoT Device Management web application.  Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.

    Args:
        application_id(str): The unique Id of the web application.
        application_name(str, optional): The name of the web application. Defaults to None.
        application_description(str, optional): An optional description of the web application. Defaults to None.
        client_token(str, optional): A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotfleethub.application.update(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotfleethub.application.update application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotfleethub",
        operation="update_application",
        op_kwargs={
            "applicationId": application_id,
            "applicationName": application_name,
            "applicationDescription": application_description,
            "clientToken": client_token,
        },
    )
