"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, detectors: List) -> Dict:
    r"""
    **Autogenerated function**

    Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.

    Args:
        detectors(List): The list of detectors (instances) to update, along with the values to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.update_detector.batch(ctx, detectors=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.update_detector.batch detectors=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_update_detector",
        op_kwargs={"detectors": detectors},
    )
