"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, snooze_action_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Changes one or more alarms to the snooze mode. The alarms change to the SNOOZE_DISABLED state after you set them to the snooze mode.

    Args:
        snooze_action_requests(List): The list of snooze action requests. You can specify up to 10 requests per operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.snooze_alarm.batch(
                ctx, snooze_action_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.snooze_alarm.batch snooze_action_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_snooze_alarm",
        op_kwargs={"snoozeActionRequests": snooze_action_requests},
    )
