"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, reset_action_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Resets one or more alarms. The alarms return to the NORMAL state after you reset them.

    Args:
        reset_action_requests(List): The list of reset action requests. You can specify up to 10 requests per operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.reset_alarm.batch(
                ctx, reset_action_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.reset_alarm.batch reset_action_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_reset_alarm",
        op_kwargs={"resetActionRequests": reset_action_requests},
    )
