"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, messages: List) -> Dict:
    r"""
    **Autogenerated function**

    Sends a set of messages to the AWS IoT Events system. Each message payload is transformed into the input you specify ("inputName") and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.

    Args:
        messages(List): The list of messages to send. Each message has the following format: '{ "messageId": "string", "inputName": "string", "payload": "string"}' .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.put_message.batch(ctx, messages=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.put_message.batch messages=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_put_message",
        op_kwargs={"messages": messages},
    )
