"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, enable_action_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Enables one or more alarms. The alarms change to the NORMAL state after you enable them.

    Args:
        enable_action_requests(List): The list of enable action requests. You can specify up to 10 requests per operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.enable_alarm.batch(
                ctx, enable_action_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.enable_alarm.batch enable_action_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_enable_alarm",
        op_kwargs={"enableActionRequests": enable_action_requests},
    )
