"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, disable_action_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Disables one or more alarms. The alarms change to the DISABLED state after you disable them.

    Args:
        disable_action_requests(List): The list of disable action requests. You can specify up to 10 requests per operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.disable_alarm.batch(
                ctx, disable_action_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.disable_alarm.batch disable_action_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_disable_alarm",
        op_kwargs={"disableActionRequests": disable_action_requests},
    )
