"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, detector_model_name: str, key_value: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified detector (instance).

    Args:
        detector_model_name(str): The name of the detector model whose detectors (instances) you want information about.
        key_value(str, optional): A filter used to limit results to detectors (instances) created because of the given key ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.detector.describe(ctx, detector_model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.detector.describe detector_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="describe_detector",
        op_kwargs={"detectorModelName": detector_model_name, "keyValue": key_value},
    )


async def list_all(
    hub,
    ctx,
    detector_model_name: str,
    state_name: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists detectors (the instances of a detector model).

    Args:
        detector_model_name(str): The name of the detector model whose detectors (instances) are listed.
        state_name(str, optional): A filter that limits results to those detectors (instances) in the given state. Defaults to None.
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.detector.list_all(ctx, detector_model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.detector.list_all detector_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="list_detectors",
        op_kwargs={
            "detectorModelName": detector_model_name,
            "stateName": state_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
