"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, acknowledge_action_requests: List) -> Dict:
    r"""
    **Autogenerated function**

    Acknowledges one or more alarms. The alarms change to the ACKNOWLEDGED state after you acknowledge them.

    Args:
        acknowledge_action_requests(List): The list of acknowledge action requests. You can specify up to 10 requests per operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent_data.acknowledge_alarm.batch(
                ctx, acknowledge_action_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent_data.acknowledge_alarm.batch acknowledge_action_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents-data",
        operation="batch_acknowledge_alarm",
        op_kwargs={"acknowledgeActionRequests": acknowledge_action_requests},
    )
