"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current settings of the AWS IoT Events logging options.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.logging_option.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.logging_option.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="describe_logging_options",
        op_kwargs={},
    )


async def put_multiple(hub, ctx, logging_options: Dict) -> None:
    r"""
    **Autogenerated function**

    Sets or updates the AWS IoT Events logging options. If you update the value of any loggingOptions field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the roleArn field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.

    Args:
        logging_options(Dict): The new values of the AWS IoT Events logging options.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.logging_option.put_multiple(ctx, logging_options=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.logging_option.put_multiple logging_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="put_logging_options",
        op_kwargs={"loggingOptions": logging_options},
    )
