"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, input_identifier: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Lists one or more input routings.

    Args:
        input_identifier(Dict):  The identifer of the routed input. .
        max_results(int, optional):  The maximum number of results to be returned per request. . Defaults to None.
        next_token(str, optional):  The token that you can use to return the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.routing.list_all(ctx, input_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.routing.list_all input_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="list_input_routings",
        op_kwargs={
            "inputIdentifier": input_identifier,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
