"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    input_name: str,
    input_definition: Dict,
    input_description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an input.

    Args:
        input_name(str): The name you want to give to the input.
        input_description(str, optional): A brief description of the input. Defaults to None.
        input_definition(Dict): The definition of the input.
        tags(List, optional): Metadata that can be used to manage the input. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.init.create(
                ctx, input_name=value, input_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.init.create input_name=value, input_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="create_input",
        op_kwargs={
            "inputName": input_name,
            "inputDescription": input_description,
            "inputDefinition": input_definition,
            "tags": tags,
        },
    )


async def delete(hub, ctx, input_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an input.

    Args:
        input_name(str): The name of the input to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.init.delete(ctx, input_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.init.delete input_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="delete_input",
        op_kwargs={"inputName": input_name},
    )


async def describe(hub, ctx, input_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an input.

    Args:
        input_name(str): The name of the input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.init.describe(ctx, input_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.init.describe input_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="describe_input",
        op_kwargs={"inputName": input_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the inputs you have created.

    Args:
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="list_inputs",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, input_name: str, input_definition: Dict, input_description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an input.

    Args:
        input_name(str): The name of the input you want to update.
        input_description(str, optional): A brief description of the input. Defaults to None.
        input_definition(Dict): The definition of the input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.input_.init.update(
                ctx, input_name=value, input_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.input_.init.update input_name=value, input_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="update_input",
        op_kwargs={
            "inputName": input_name,
            "inputDescription": input_description,
            "inputDefinition": input_definition,
        },
    )
