"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, detector_model_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.

    Args:
        detector_model_name(str): The name of the detector model whose versions are returned.
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.version.list_all(
                ctx, detector_model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.version.list_all detector_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="list_detector_model_versions",
        op_kwargs={
            "detectorModelName": detector_model_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
