"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    detector_model_name: str,
    detector_model_definition: Dict,
    role_arn: str,
    detector_model_description: str = None,
    key: str = None,
    tags: List = None,
    evaluation_method: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a detector model.

    Args:
        detector_model_name(str): The name of the detector model.
        detector_model_definition(Dict): Information that defines how the detectors operate.
        detector_model_description(str, optional): A brief description of the detector model. Defaults to None.
        key(str, optional): The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input. Defaults to None.
        role_arn(str): The ARN of the role that grants permission to AWS IoT Events to perform its operations.
        tags(List, optional): Metadata that can be used to manage the detector model. Defaults to None.
        evaluation_method(str, optional): Information about the order in which events are evaluated and how actions are executed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.init.create(
                ctx, detector_model_name=value, detector_model_definition=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.init.create detector_model_name=value, detector_model_definition=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="create_detector_model",
        op_kwargs={
            "detectorModelName": detector_model_name,
            "detectorModelDefinition": detector_model_definition,
            "detectorModelDescription": detector_model_description,
            "key": key,
            "roleArn": role_arn,
            "tags": tags,
            "evaluationMethod": evaluation_method,
        },
    )


async def delete(hub, ctx, detector_model_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a detector model. Any active instances of the detector model are also deleted.

    Args:
        detector_model_name(str): The name of the detector model to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.init.delete(
                ctx, detector_model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.init.delete detector_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="delete_detector_model",
        op_kwargs={"detectorModelName": detector_model_name},
    )


async def describe(
    hub, ctx, detector_model_name: str, detector_model_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a detector model. If the version parameter is not specified, information about the latest version is returned.

    Args:
        detector_model_name(str): The name of the detector model.
        detector_model_version(str, optional): The version of the detector model. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.init.describe(
                ctx, detector_model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.init.describe detector_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="describe_detector_model",
        op_kwargs={
            "detectorModelName": detector_model_name,
            "detectorModelVersion": detector_model_version,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the detector models you have created. Only the metadata associated with each detector model is returned.

    Args:
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="list_detector_models",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    detector_model_name: str,
    detector_model_definition: Dict,
    role_arn: str,
    detector_model_description: str = None,
    evaluation_method: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.

    Args:
        detector_model_name(str): The name of the detector model that is updated.
        detector_model_definition(Dict): Information that defines how a detector operates.
        detector_model_description(str, optional): A brief description of the detector model. Defaults to None.
        role_arn(str): The ARN of the role that grants permission to AWS IoT Events to perform its operations.
        evaluation_method(str, optional): Information about the order in which events are evaluated and how actions are executed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.init.update(
                ctx, detector_model_name=value, detector_model_definition=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.init.update detector_model_name=value, detector_model_definition=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="update_detector_model",
        op_kwargs={
            "detectorModelName": detector_model_name,
            "detectorModelDefinition": detector_model_definition,
            "detectorModelDescription": detector_model_description,
            "roleArn": role_arn,
            "evaluationMethod": evaluation_method,
        },
    )
