"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, analysis_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves one or more analysis results of the detector model.  After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.

    Args:
        analysis_id(str): The ID of the analysis result that you want to retrieve.
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.analysis.result.get_all(
                ctx, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.analysis.result.get_all analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="get_detector_model_analysis_results",
        op_kwargs={
            "analysisId": analysis_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
