"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, analysis_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves runtime information about a detector model analysis.  After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.

    Args:
        analysis_id(str): The ID of the analysis result that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.analysis.init.describe(
                ctx, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.analysis.init.describe analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="describe_detector_model_analysis",
        op_kwargs={"analysisId": analysis_id},
    )


async def start(hub, ctx, detector_model_definition: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Performs an analysis of your detector model. For more information, see Troubleshooting a detector model in the AWS IoT Events Developer Guide.

    Args:
        detector_model_definition(Dict): Information that defines how a detector operates.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.detector_model.analysis.init.start(
                ctx, detector_model_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.detector_model.analysis.init.start detector_model_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="start_detector_model_analysis",
        op_kwargs={"detectorModelDefinition": detector_model_definition},
    )
