"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    alarm_model_name: str,
    role_arn: str,
    alarm_rule: Dict,
    alarm_model_description: str = None,
    tags: List = None,
    key: str = None,
    severity: int = None,
    alarm_notification: Dict = None,
    alarm_event_actions: Dict = None,
    alarm_capabilities: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see Create an alarm model in the AWS IoT Events Developer Guide.

    Args:
        alarm_model_name(str): A unique name that helps you identify the alarm model. You can't change this name after you create the alarm model.
        alarm_model_description(str, optional): A description that tells you what the alarm model detects. Defaults to None.
        role_arn(str): The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see Amazon Resource Names (ARNs) in the AWS General Reference.
        tags(List, optional): A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see Tagging your AWS IoT Events resources in the AWS IoT Events Developer Guide. You can create up to 50 tags for one alarm model. Defaults to None.
        key(str, optional): An input attribute used as a key to create an alarm. AWS IoT Events routes inputs associated with this key to the alarm. Defaults to None.
        severity(int, optional): A non-negative integer that reflects the severity level of the alarm. Defaults to None.
        alarm_rule(Dict): Defines when your alarm is invoked.
        alarm_notification(Dict, optional): Contains information about one or more notification actions. Defaults to None.
        alarm_event_actions(Dict, optional): Contains information about one or more alarm actions. Defaults to None.
        alarm_capabilities(Dict, optional): Contains the configuration information of alarm state changes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.alarm_model.init.create(
                ctx, alarm_model_name=value, role_arn=value, alarm_rule=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.alarm_model.init.create alarm_model_name=value, role_arn=value, alarm_rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="create_alarm_model",
        op_kwargs={
            "alarmModelName": alarm_model_name,
            "alarmModelDescription": alarm_model_description,
            "roleArn": role_arn,
            "tags": tags,
            "key": key,
            "severity": severity,
            "alarmRule": alarm_rule,
            "alarmNotification": alarm_notification,
            "alarmEventActions": alarm_event_actions,
            "alarmCapabilities": alarm_capabilities,
        },
    )


async def delete(hub, ctx, alarm_model_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.

    Args:
        alarm_model_name(str): The name of the alarm model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.alarm_model.init.delete(ctx, alarm_model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.alarm_model.init.delete alarm_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="delete_alarm_model",
        op_kwargs={"alarmModelName": alarm_model_name},
    )


async def describe(
    hub, ctx, alarm_model_name: str, alarm_model_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an alarm model. If you don't specify a value for the alarmModelVersion parameter, the latest version is returned.

    Args:
        alarm_model_name(str): The name of the alarm model.
        alarm_model_version(str, optional): The version of the alarm model. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.alarm_model.init.describe(ctx, alarm_model_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.alarm_model.init.describe alarm_model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="describe_alarm_model",
        op_kwargs={
            "alarmModelName": alarm_model_name,
            "alarmModelVersion": alarm_model_version,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.

    Args:
        next_token(str, optional): The token that you can use to return the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.alarm_model.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.alarm_model.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="list_alarm_models",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    alarm_model_name: str,
    role_arn: str,
    alarm_rule: Dict,
    alarm_model_description: str = None,
    severity: int = None,
    alarm_notification: Dict = None,
    alarm_event_actions: Dict = None,
    alarm_capabilities: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.

    Args:
        alarm_model_name(str): The name of the alarm model.
        alarm_model_description(str, optional): The description of the alarm model. Defaults to None.
        role_arn(str): The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see Amazon Resource Names (ARNs) in the AWS General Reference.
        severity(int, optional): A non-negative integer that reflects the severity level of the alarm. Defaults to None.
        alarm_rule(Dict): Defines when your alarm is invoked.
        alarm_notification(Dict, optional): Contains information about one or more notification actions. Defaults to None.
        alarm_event_actions(Dict, optional): Contains information about one or more alarm actions. Defaults to None.
        alarm_capabilities(Dict, optional): Contains the configuration information of alarm state changes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotevent.alarm_model.init.update(
                ctx, alarm_model_name=value, role_arn=value, alarm_rule=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotevent.alarm_model.init.update alarm_model_name=value, role_arn=value, alarm_rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotevents",
        operation="update_alarm_model",
        op_kwargs={
            "alarmModelName": alarm_model_name,
            "alarmModelDescription": alarm_model_description,
            "roleArn": role_arn,
            "severity": severity,
            "alarmRule": alarm_rule,
            "alarmNotification": alarm_notification,
            "alarmEventActions": alarm_event_actions,
            "alarmCapabilities": alarm_capabilities,
        },
    )
