"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, suite_definition_id: str, suite_run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a report download link for a successful Device Advisor qualifying test suite run.

    Args:
        suite_definition_id(str): Suite definition Id of the test suite.
        suite_run_id(str): Suite run Id of the test suite run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotdeviceadvisor.suite.run.report.get(
                ctx, suite_definition_id=value, suite_run_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotdeviceadvisor.suite.run.report.get suite_definition_id=value, suite_run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotdeviceadvisor",
        operation="get_suite_run_report",
        op_kwargs={
            "suiteDefinitionId": suite_definition_id,
            "suiteRunId": suite_run_id,
        },
    )
