"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, suite_definition_id: str, suite_run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Device Advisor test suite run.

    Args:
        suite_definition_id(str): Suite definition Id for the test suite run.
        suite_run_id(str): Suite run Id for the test suite run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotdeviceadvisor.suite.run.init.get(
                ctx, suite_definition_id=value, suite_run_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotdeviceadvisor.suite.run.init.get suite_definition_id=value, suite_run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotdeviceadvisor",
        operation="get_suite_run",
        op_kwargs={
            "suiteDefinitionId": suite_definition_id,
            "suiteRunId": suite_run_id,
        },
    )


async def list_all(
    hub,
    ctx,
    suite_definition_id: str = None,
    suite_definition_version: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.

    Args:
        suite_definition_id(str, optional): Lists the test suite runs of the specified test suite based on suite definition Id. Defaults to None.
        suite_definition_version(str, optional): Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version. Defaults to None.
        max_results(int, optional): The maximum number of results to return at once. Defaults to None.
        next_token(str, optional): A token to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotdeviceadvisor.suite.run.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotdeviceadvisor.suite.run.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotdeviceadvisor",
        operation="list_suite_runs",
        op_kwargs={
            "suiteDefinitionId": suite_definition_id,
            "suiteDefinitionVersion": suite_definition_version,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    suite_definition_id: str,
    suite_definition_version: str = None,
    suite_run_configuration: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a Device Advisor test suite run.

    Args:
        suite_definition_id(str): Suite definition Id of the test suite.
        suite_definition_version(str, optional): Suite definition version of the test suite. Defaults to None.
        suite_run_configuration(Dict, optional): Suite run configuration. Defaults to None.
        tags(Dict, optional): The tags to be attached to the suite run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotdeviceadvisor.suite.run.init.start(
                ctx, suite_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotdeviceadvisor.suite.run.init.start suite_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotdeviceadvisor",
        operation="start_suite_run",
        op_kwargs={
            "suiteDefinitionId": suite_definition_id,
            "suiteDefinitionVersion": suite_definition_version,
            "suiteRunConfiguration": suite_run_configuration,
            "tags": tags,
        },
    )


async def stop(hub, ctx, suite_definition_id: str, suite_run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a Device Advisor test suite run that is currently running.

    Args:
        suite_definition_id(str): Suite definition Id of the test suite run to be stopped.
        suite_run_id(str): Suite run Id of the test suite run to be stopped.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotdeviceadvisor.suite.run.init.stop(
                ctx, suite_definition_id=value, suite_run_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotdeviceadvisor.suite.run.init.stop suite_definition_id=value, suite_run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotdeviceadvisor",
        operation="stop_suite_run",
        op_kwargs={
            "suiteDefinitionId": suite_definition_id,
            "suiteRunId": suite_run_id,
        },
    )
