"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, channel_name: str, messages: List) -> Dict:
    r"""
    **Autogenerated function**

    Sends messages to a channel.

    Args:
        channel_name(str): The name of the channel where the messages are sent.
        messages(List): The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}. The field names of message payloads (data) that you send to IoT Analytics:   Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.   Must begin with an alphabetic character or single underscore (_).   Cannot contain hyphens (-).   In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".    Cannot be more than 255 characters.   Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)   For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.put_message.batch(
                ctx, channel_name=value, messages=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.put_message.batch channel_name=value, messages=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="batch_put_message",
        op_kwargs={"channelName": channel_name, "messages": messages},
    )
