"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, pipeline_name: str, reprocessing_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the reprocessing of data through the pipeline.

    Args:
        pipeline_name(str): The name of pipeline for which data reprocessing is canceled.
        reprocessing_id(str): The ID of the reprocessing task (returned by StartPipelineReprocessing).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.pipeline.reprocessing.cancel(
                ctx, pipeline_name=value, reprocessing_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.pipeline.reprocessing.cancel pipeline_name=value, reprocessing_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="cancel_pipeline_reprocessing",
        op_kwargs={"pipelineName": pipeline_name, "reprocessingId": reprocessing_id},
    )


async def start(
    hub,
    ctx,
    pipeline_name: str,
    start_time: str = None,
    end_time: str = None,
    channel_messages: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the reprocessing of raw message data through the pipeline.

    Args:
        pipeline_name(str): The name of the pipeline on which to start reprocessing.
        start_time(str, optional): The start time (inclusive) of raw message data that is reprocessed. If you specify a value for the startTime parameter, you must not use the channelMessages object. Defaults to None.
        end_time(str, optional): The end time (exclusive) of raw message data that is reprocessed. If you specify a value for the endTime parameter, you must not use the channelMessages object. Defaults to None.
        channel_messages(Dict, optional): Specifies one or more sets of channel messages that you want to reprocess. If you use the channelMessages object, you must not specify a value for startTime and endTime. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.pipeline.reprocessing.start(
                ctx, pipeline_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.pipeline.reprocessing.start pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="start_pipeline_reprocessing",
        op_kwargs={
            "pipelineName": pipeline_name,
            "startTime": start_time,
            "endTime": end_time,
            "channelMessages": channel_messages,
        },
    )
