"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def run(hub, ctx, pipeline_activity: Dict, payloads: List) -> Dict:
    r"""
    **Autogenerated function**

    Simulates the results of running a pipeline activity on a message payload.

    Args:
        pipeline_activity(Dict): The pipeline activity that is run. This must not be a channel activity or a data store activity because these activities are used in a pipeline only to load the original message and to store the (possibly) transformed message. If a Lambda activity is specified, only short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be used.
        payloads(List): The sample message payloads on which the pipeline activity is run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.pipeline.activity.run(
                ctx, pipeline_activity=value, payloads=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.pipeline.activity.run pipeline_activity=value, payloads=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="run_pipeline_activity",
        op_kwargs={"pipelineActivity": pipeline_activity, "payloads": payloads},
    )
