"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    datastore_name: str,
    datastore_storage: Dict = None,
    retention_period: Dict = None,
    tags: List = None,
    file_format_configuration: Dict = None,
    datastore_partitions: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a data store, which is a repository for messages.

    Args:
        datastore_name(str): The name of the data store.
        datastore_storage(Dict, optional): Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created. . Defaults to None.
        retention_period(Dict, optional): How long, in days, message data is kept for the data store. When customerManagedS3 storage is selected, this parameter is ignored. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the data store. Defaults to None.
        file_format_configuration(Dict, optional): Contains the configuration information of file formats. IoT Analytics data stores support JSON and Parquet. The default file format is JSON. You can specify only one format. You can't change the file format after you create the data store. Defaults to None.
        datastore_partitions(Dict, optional):  Contains information about the partition dimensions in a data store. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.datastore.create(ctx, datastore_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.datastore.create datastore_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="create_datastore",
        op_kwargs={
            "datastoreName": datastore_name,
            "datastoreStorage": datastore_storage,
            "retentionPeriod": retention_period,
            "tags": tags,
            "fileFormatConfiguration": file_format_configuration,
            "datastorePartitions": datastore_partitions,
        },
    )


async def delete(hub, ctx, datastore_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified data store.

    Args:
        datastore_name(str): The name of the data store to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.datastore.delete(ctx, datastore_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.datastore.delete datastore_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="delete_datastore",
        op_kwargs={"datastoreName": datastore_name},
    )


async def describe(
    hub, ctx, datastore_name: str, include_statistics: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a data store.

    Args:
        datastore_name(str): The name of the data store.
        include_statistics(bool, optional): If true, additional statistical information about the data store is included in the response. This feature can't be used with a data store whose S3 storage is customer-managed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.datastore.describe(ctx, datastore_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.datastore.describe datastore_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="describe_datastore",
        op_kwargs={
            "datastoreName": datastore_name,
            "includeStatistics": include_statistics,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of data stores.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.datastore.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.datastore.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="list_datastores",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    datastore_name: str,
    retention_period: Dict = None,
    datastore_storage: Dict = None,
    file_format_configuration: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Used to update the settings of a data store.

    Args:
        datastore_name(str): The name of the data store to be updated.
        retention_period(Dict, optional): How long, in days, message data is kept for the data store. The retention period can't be updated if the data store's Amazon S3 storage is customer-managed. Defaults to None.
        datastore_storage(Dict, optional): Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created. . Defaults to None.
        file_format_configuration(Dict, optional): Contains the configuration information of file formats. IoT Analytics data stores support JSON and Parquet. The default file format is JSON. You can specify only one format. You can't change the file format after you create the data store. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.datastore.update(ctx, datastore_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.datastore.update datastore_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="update_datastore",
        op_kwargs={
            "datastoreName": datastore_name,
            "retentionPeriod": retention_period,
            "datastoreStorage": datastore_storage,
            "fileFormatConfiguration": file_format_configuration,
        },
    )
