"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dataset_name: str,
    actions: List,
    triggers: List = None,
    content_delivery_rules: List = None,
    retention_period: Dict = None,
    versioning_configuration: Dict = None,
    tags: List = None,
    late_data_rules: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to create a dataset. A dataset stores data retrieved from a data store by applying a queryAction (a SQL query) or a containerAction (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling CreateDatasetContent or automatically according to a trigger you specify.

    Args:
        dataset_name(str): The name of the dataset.
        actions(List): A list of actions that create the dataset contents.
        triggers(List, optional): A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five DataSetTrigger objects. Defaults to None.
        content_delivery_rules(List, optional): When dataset contents are created, they are delivered to destinations specified here. Defaults to None.
        retention_period(Dict, optional): Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to null, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the versioningConfiguration parameter. For more information, see  Keeping Multiple Versions of IoT Analytics datasets in the IoT Analytics User Guide. Defaults to None.
        versioning_configuration(Dict, optional): Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the retentionPeriod parameter. For more information, see Keeping Multiple Versions of IoT Analytics datasets in the IoT Analytics User Guide. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the dataset. Defaults to None.
        late_data_rules(List, optional): A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a DeltaTimer filter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.init.create(
                ctx, dataset_name=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.init.create dataset_name=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="create_dataset",
        op_kwargs={
            "datasetName": dataset_name,
            "actions": actions,
            "triggers": triggers,
            "contentDeliveryRules": content_delivery_rules,
            "retentionPeriod": retention_period,
            "versioningConfiguration": versioning_configuration,
            "tags": tags,
            "lateDataRules": late_data_rules,
        },
    )


async def delete(hub, ctx, dataset_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified dataset. You do not have to delete the content of the dataset before you perform this operation.

    Args:
        dataset_name(str): The name of the dataset to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.init.delete(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.init.delete dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="delete_dataset",
        op_kwargs={"datasetName": dataset_name},
    )


async def describe(hub, ctx, dataset_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a dataset.

    Args:
        dataset_name(str): The name of the dataset whose information is retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.init.describe(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.init.describe dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="describe_dataset",
        op_kwargs={"datasetName": dataset_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about datasets.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="list_datasets",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    dataset_name: str,
    actions: List,
    triggers: List = None,
    content_delivery_rules: List = None,
    retention_period: Dict = None,
    versioning_configuration: Dict = None,
    late_data_rules: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the settings of a dataset.

    Args:
        dataset_name(str): The name of the dataset to update.
        actions(List): A list of DatasetAction objects.
        triggers(List, optional): A list of DatasetTrigger objects. The list can be empty or can contain up to five DatasetTrigger objects. Defaults to None.
        content_delivery_rules(List, optional): When dataset contents are created, they are delivered to destinations specified here. Defaults to None.
        retention_period(Dict, optional): How long, in days, dataset contents are kept for the dataset. Defaults to None.
        versioning_configuration(Dict, optional): Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the retentionPeriod parameter. For more information, see Keeping Multiple Versions of IoT Analytics datasets in the IoT Analytics User Guide. Defaults to None.
        late_data_rules(List, optional): A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a DeltaTimer filter. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.init.update(
                ctx, dataset_name=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.init.update dataset_name=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="update_dataset",
        op_kwargs={
            "datasetName": dataset_name,
            "actions": actions,
            "triggers": triggers,
            "contentDeliveryRules": content_delivery_rules,
            "retentionPeriod": retention_period,
            "versioningConfiguration": versioning_configuration,
            "lateDataRules": late_data_rules,
        },
    )
