"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, dataset_name: str, version_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates the content of a dataset by applying a queryAction (a SQL query) or a containerAction (executing a containerized application).

    Args:
        dataset_name(str): The name of the dataset.
        version_id(str, optional): The version ID of the dataset content. To specify versionId for a dataset content, the dataset must use a DeltaTimer filter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.content.create(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.content.create dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="create_dataset_content",
        op_kwargs={"datasetName": dataset_name, "versionId": version_id},
    )


async def delete(hub, ctx, dataset_name: str, version_id: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the content of the specified dataset.

    Args:
        dataset_name(str): The name of the dataset whose content is deleted.
        version_id(str, optional): The version of the dataset whose content is deleted. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.content.delete(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.content.delete dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="delete_dataset_content",
        op_kwargs={"datasetName": dataset_name, "versionId": version_id},
    )


async def get(hub, ctx, dataset_name: str, version_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the contents of a dataset as presigned URIs.

    Args:
        dataset_name(str): The name of the dataset whose contents are retrieved.
        version_id(str, optional): The version of the dataset whose contents are retrieved. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.content.get(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.content.get dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="get_dataset_content",
        op_kwargs={"datasetName": dataset_name, "versionId": version_id},
    )


async def list_all(
    hub,
    ctx,
    dataset_name: str,
    next_token: str = None,
    max_results: int = None,
    scheduled_on_or_after: str = None,
    scheduled_before: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about dataset contents that have been created.

    Args:
        dataset_name(str): The name of the dataset whose contents information you want to list.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. Defaults to None.
        scheduled_on_or_after(str, optional): A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field triggers.schedule in the CreateDataset request. (timestamp). Defaults to None.
        scheduled_before(str, optional): A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field triggers.schedule in the CreateDataset request. (timestamp). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.dataset.content.list_all(ctx, dataset_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.dataset.content.list_all dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="list_dataset_contents",
        op_kwargs={
            "datasetName": dataset_name,
            "nextToken": next_token,
            "maxResults": max_results,
            "scheduledOnOrAfter": scheduled_on_or_after,
            "scheduledBefore": scheduled_before,
        },
    )
