"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    channel_name: str,
    channel_storage: Dict = None,
    retention_period: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.

    Args:
        channel_name(str): The name of the channel.
        channel_storage(Dict, optional): Where channel data is stored. You can choose one of serviceManagedS3 or customerManagedS3 storage. If not specified, the default is serviceManagedS3. You can't change this storage option after the channel is created. Defaults to None.
        retention_period(Dict, optional): How long, in days, message data is kept for the channel. When customerManagedS3 storage is selected, this parameter is ignored. Defaults to None.
        tags(List, optional): Metadata which can be used to manage the channel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.init.create(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.init.create channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="create_channel",
        op_kwargs={
            "channelName": channel_name,
            "channelStorage": channel_storage,
            "retentionPeriod": retention_period,
            "tags": tags,
        },
    )


async def delete(hub, ctx, channel_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified channel.

    Args:
        channel_name(str): The name of the channel to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.init.delete(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.init.delete channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="delete_channel",
        op_kwargs={"channelName": channel_name},
    )


async def describe(
    hub, ctx, channel_name: str, include_statistics: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a channel.

    Args:
        channel_name(str): The name of the channel whose information is retrieved.
        include_statistics(bool, optional): If true, additional statistical information about the channel is included in the response. This feature can't be used with a channel whose S3 storage is customer-managed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.init.describe(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.init.describe channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="describe_channel",
        op_kwargs={
            "channelName": channel_name,
            "includeStatistics": include_statistics,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of channels.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="list_channels",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    channel_name: str,
    channel_storage: Dict = None,
    retention_period: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Used to update the settings of a channel.

    Args:
        channel_name(str): The name of the channel to be updated.
        channel_storage(Dict, optional): Where channel data is stored. You can choose one of serviceManagedS3 or customerManagedS3 storage. If not specified, the default is serviceManagedS3. You can't change this storage option after the channel is created. Defaults to None.
        retention_period(Dict, optional): How long, in days, message data is kept for the channel. The retention period can't be updated if the channel's Amazon S3 storage is customer-managed. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.init.update(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.init.update channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="update_channel",
        op_kwargs={
            "channelName": channel_name,
            "channelStorage": channel_storage,
            "retentionPeriod": retention_period,
        },
    )
