"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def sample(
    hub,
    ctx,
    channel_name: str,
    max_messages: int = None,
    start_time: str = None,
    end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.

    Args:
        channel_name(str): The name of the channel whose message samples are retrieved.
        max_messages(int, optional): The number of sample messages to be retrieved. The limit is 10. The default is also 10. Defaults to None.
        start_time(str, optional): The start of the time window from which sample messages are retrieved. Defaults to None.
        end_time(str, optional): The end of the time window from which sample messages are retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotanalytic.channel.data.sample(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotanalytic.channel.data.sample channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotanalytics",
        operation="sample_channel_data",
        op_kwargs={
            "channelName": channel_name,
            "maxMessages": max_messages,
            "startTime": start_time,
            "endTime": end_time,
        },
    )
