"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    thing_name: str,
    status_details: Dict = None,
    step_timeout_in_minutes: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution for a thing.

    Args:
        thing_name(str): The name of the thing associated with the device.
        status_details(Dict, optional): A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. Defaults to None.
        step_timeout_in_minutes(int, optional): Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by calling UpdateJobExecution, setting the status to IN_PROGRESS and specifying a new timeout value in field stepTimeoutInMinutes) the job execution status will be automatically set to TIMED_OUT. Note that setting this timeout has no effect on that job execution timeout which may have been specified when the job was created (CreateJob using field timeoutConfig). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_jobs_data.next_pending_job_execution.start(
                ctx, thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_jobs_data.next_pending_job_execution.start thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-jobs-data",
        operation="start_next_pending_job_execution",
        op_kwargs={
            "thingName": thing_name,
            "statusDetails": status_details,
            "stepTimeoutInMinutes": step_timeout_in_minutes,
        },
    )
