"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    job_id: str,
    thing_name: str,
    include_job_document: bool = None,
    execution_number: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets details of a job execution.

    Args:
        job_id(str): The unique identifier assigned to this job when it was created.
        thing_name(str): The thing name associated with the device the job execution is running on.
        include_job_document(bool, optional): Optional. When set to true, the response contains the job document. The default is false. Defaults to None.
        execution_number(int, optional): Optional. A number that identifies a particular job execution on a particular device. If not specified, the latest job execution is returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_jobs_data.job_execution.describe(
                ctx, job_id=value, thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_jobs_data.job_execution.describe job_id=value, thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-jobs-data",
        operation="describe_job_execution",
        op_kwargs={
            "jobId": job_id,
            "thingName": thing_name,
            "includeJobDocument": include_job_document,
            "executionNumber": execution_number,
        },
    )


async def update(
    hub,
    ctx,
    job_id: str,
    thing_name: str,
    status: str,
    status_details: Dict = None,
    step_timeout_in_minutes: int = None,
    expected_version: int = None,
    include_job_execution_state: bool = None,
    include_job_document: bool = None,
    execution_number: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of a job execution.

    Args:
        job_id(str): The unique identifier assigned to this job when it was created.
        thing_name(str): The name of the thing associated with the device.
        status(str): The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every update.
        status_details(Dict, optional):  Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. Defaults to None.
        step_timeout_in_minutes(int, optional): Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by again calling UpdateJobExecution, setting the status to IN_PROGRESS and specifying a new timeout value in this field) the job execution status will be automatically set to TIMED_OUT. Note that setting or resetting this timeout has no effect on that job execution timeout which may have been specified when the job was created (CreateJob using field timeoutConfig). Defaults to None.
        expected_version(int, optional): Optional. The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.). Defaults to None.
        include_job_execution_state(bool, optional): Optional. When included and set to true, the response contains the JobExecutionState data. The default is false. Defaults to None.
        include_job_document(bool, optional): Optional. When set to true, the response contains the job document. The default is false. Defaults to None.
        execution_number(int, optional): Optional. A number that identifies a particular job execution on a particular device. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_jobs_data.job_execution.update(
                ctx, job_id=value, thing_name=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_jobs_data.job_execution.update job_id=value, thing_name=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-jobs-data",
        operation="update_job_execution",
        op_kwargs={
            "jobId": job_id,
            "thingName": thing_name,
            "status": status,
            "statusDetails": status_details,
            "stepTimeoutInMinutes": step_timeout_in_minutes,
            "expectedVersion": expected_version,
            "includeJobExecutionState": include_job_execution_state,
            "includeJobDocument": include_job_document,
            "executionNumber": execution_number,
        },
    )
