"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, thing_name: str, shadow_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the shadow for the specified thing. For more information, see DeleteThingShadow in the AWS IoT Developer Guide.

    Args:
        thing_name(str): The name of the thing.
        shadow_name(str, optional): The name of the shadow. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_data.thing_shadow.delete(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_data.thing_shadow.delete thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-data",
        operation="delete_thing_shadow",
        op_kwargs={"thingName": thing_name, "shadowName": shadow_name},
    )


async def get(hub, ctx, thing_name: str, shadow_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the shadow for the specified thing. For more information, see GetThingShadow in the AWS IoT Developer Guide.

    Args:
        thing_name(str): The name of the thing.
        shadow_name(str, optional): The name of the shadow. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_data.thing_shadow.get(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_data.thing_shadow.get thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-data",
        operation="get_thing_shadow",
        op_kwargs={"thingName": thing_name, "shadowName": shadow_name},
    )


async def update(
    hub, ctx, thing_name: str, payload: bytes, shadow_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the shadow for the specified thing. For more information, see UpdateThingShadow in the AWS IoT Developer Guide.

    Args:
        thing_name(str): The name of the thing.
        shadow_name(str, optional): The name of the shadow. Defaults to None.
        payload(bytes): The state information, in JSON format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_data.thing_shadow.update(
                ctx, thing_name=value, payload=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_data.thing_shadow.update thing_name=value, payload=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-data",
        operation="update_thing_shadow",
        op_kwargs={
            "thingName": thing_name,
            "shadowName": shadow_name,
            "payload": payload,
        },
    )
