"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, thing_name: str, next_token: str = None, page_size: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the shadows for the specified thing.

    Args:
        thing_name(str): The name of the thing.
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.
        page_size(int, optional): The result page size. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_data.named_shadow_for_thing.list(ctx, thing_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_data.named_shadow_for_thing.list thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-data",
        operation="list_named_shadows_for_thing",
        op_kwargs={
            "thingName": thing_name,
            "nextToken": next_token,
            "pageSize": page_size,
        },
    )
