"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def publish(hub, ctx, topic: str, qos: int = None, payload: bytes = None) -> None:
    r"""
    **Autogenerated function**

    Publishes state information. For more information, see HTTP Protocol in the AWS IoT Developer Guide.

    Args:
        topic(str): The name of the MQTT topic.
        qos(int, optional): The Quality of Service (QoS) level. Defaults to None.
        payload(bytes, optional): The state information, in JSON format. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot_data.init.publish(ctx, topic=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot_data.init.publish topic=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot-data",
        operation="publish",
        op_kwargs={"topic": topic, "qos": qos, "payload": payload},
    )
