"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    project_name: str,
    description: str = None,
    placement_template: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty project with a placement template. A project contains zero or more placements that adhere to the placement template defined in the project.

    Args:
        project_name(str): The name of the project to create.
        description(str, optional): An optional description for the project. Defaults to None.
        placement_template(Dict, optional): The schema defining the placement to be created. A placement template defines placement default attributes and device templates. You cannot add or remove device templates after the project has been created. However, you can update callbackOverrides for the device templates using the UpdateProject API. Defaults to None.
        tags(Dict, optional): Optional tags (metadata key/value pairs) to be associated with the project. For example, { {"key1": "value1", "key2": "value2"} }. For more information, see AWS Tagging Strategies. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.project.create(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.project.create project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="create_project",
        op_kwargs={
            "projectName": project_name,
            "description": description,
            "placementTemplate": placement_template,
            "tags": tags,
        },
    )


async def delete(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a project. To delete a project, it must not have any placements associated with it.  When you delete a project, all associated data becomes irretrievable.

    Args:
        project_name(str): The name of the empty project to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.project.delete(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.project.delete project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="delete_project",
        op_kwargs={"projectName": project_name},
    )


async def describe(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an object describing a project.

    Args:
        project_name(str): The name of the project to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.project.describe(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.project.describe project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="describe_project",
        op_kwargs={"projectName": project_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.

    Args:
        next_token(str, optional): The token to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per request. If not set, a default value of 100 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="list_projects",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    project_name: str,
    description: str = None,
    placement_template: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a project associated with your AWS account and region. With the exception of device template names, you can pass just the values that need to be updated because the update request will change only the values that are provided. To clear a value, pass the empty string (i.e., "").

    Args:
        project_name(str): The name of the project to be updated.
        description(str, optional): An optional user-defined description for the project. Defaults to None.
        placement_template(Dict, optional): An object defining the project update. Once a project has been created, you cannot add device template names to the project. However, for a given placementTemplate, you can update the associated callbackOverrides for the device definition using this API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iot1click_project.project.update(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iot1click_project.project.update project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iot1click-projects",
        operation="update_project",
        op_kwargs={
            "projectName": project_name,
            "description": description,
            "placementTemplate": placement_template,
        },
    )
